#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Cube FieldMod01.fsh  by  Mr_E 
//https://www.shadertoy.com/view/MdtXzn
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}

float opU( float d1, float d2 )
{
    return min(d1,d2);
}
vec3 opRep( vec3 p, vec3 c )
{
    return mod(p,c)-0.5*c;
}


float sdGrid(vec3 p) {
	return opU(opU(sdBox(p,vec3(5.,.8,.3)),
               sdBox(p,vec3(1.31,55.2,.3))),
               sdBox(p,vec3(0.,0.,0.)));
}
float sdCross(vec3 p) {
	return opU(sdBox(p,vec3(0.,0.,0.)),
            sdBox(p,vec3(2.6,2.6,2.6)));
}
float smin( float a, float b, float k )
{
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}

float sdCrossedGrid( vec3 p )
{
    float d1 = sdCross(p);
    float d2 = sdGrid(p);
    return smin( d1, d1, d1);
}

vec2 distance_to_obj(in vec3 p) {

p = mod(p, 10.) - 5.; // Repeat space.

// Unsigned rounded box.
// vec3(2.) - Box dimensions, and the last term for roundness.

float rBox = length(max(abs(p)- vec3(2.), 0.0)) - 0.2;

return vec2(rBox, 1.);
}


// primitive color
vec3 prim_c(in vec3 p) {
    //return vec3(0.6,0.6,0.8);
    return vec3(sin(p.x*p.y*p.z/10.),cos(p.x*p.y*p.z/5.),.5);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 cam_pos = vec3(cos(iTime/5.)*20.0,sin(iTime/5.)*40.0,20.0);

	vec2 tx = fragCoord.xy / iResolution.xy;
    vec2 vPos = -1.0 + 2.0 * tx;

    //camera up vector
    vec3 vuv = vec3(0,1,1);

    //camera lookat
    vec3 vrp=vec3(0,1,0);

    vec3 prp = cam_pos;
    vec3 vpn = normalize(vrp-prp);
    vec3 u = normalize(cross(vuv,vpn));
    vec3 v = cross(vpn,u);
    vec3 vcv = (prp+vpn);
    vec3 scrCoord = vcv+vPos.x*u*1.0+vPos.y*v*1.0;
    vec3 scp=normalize(scrCoord-prp);

    //Raymarching
    const vec3 e=vec3(0.04,0,0.8);
    const float maxd=200.0;
    vec2 d=vec2(1.02,1.0);
    vec3 c,p,N;

    float f=1.0;
    for(int i=0;i<256;i++) { // Change i value to 256 for 3D-ness and 2 for coolness
        if ((abs(d.x)<.001) || (f > maxd)) break;

        f+=d.x*0.8;
        p=prp+scp*f;
        d = distance_to_obj(p);
    }
    if (f<maxd) {
        c=prim_c(p);
        vec3 n = vec3(
            d.x-distance_to_obj(p-e.xyy).x,
            d.x-distance_to_obj(p-e.yxy).x,
            d.x-distance_to_obj(p-e.yyx).x
            );
        N = normalize(n);
        
        float b=dot(N,normalize(prp-p));
		vec2 xy = fragCoord.xy / iResolution.xy;//Condensing this into one line
    	xy.y = 1.0 - xy.y;
    	
        vec2 uv = fragCoord.xy/iResolution.xy;
		vec4 texColor = texture(iChannel0,xy,b);//Get the pixel at xy from iChannel0
        fragColor = vec4(b);
        
        //fragColor = vec4(b, 0.1, b, cos(iTime));//Set the screen pixel to that color
    } else {
    fragColor=vec4(0,0,0,1);
    }
    fragColor *= 1./(1.+f*f*.001);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

